package com.hero.objects.powers;

import org.jdom.Element;

import com.hero.HeroDesigner;
import com.hero.objects.GenericObject;
import com.hero.ui.dialog.GenericDialog;
import com.hero.ui.dialog.PowerDialog;
import com.hero.util.XMLUtility;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class Automaton extends Power {

	private static String xmlID = "AUTOMATON";

	private int basePDEDDenomenator;

	private int defenseCostMultiplier;

	public Automaton(Element root) {
		super(root, Automaton.xmlID);
	}

	/**
	 * The amount to divide the base PD and ED Characteristics by.
	 * 
	 * @return
	 */
	public int getBasePDEDDenomenator() {
		if (basePDEDDenomenator <= 0) {
			basePDEDDenomenator = 3;
		}
		return basePDEDDenomenator;
	}

	@Override
	public String getColumn2Output() {
		String ret = getSelectedOption().getAlias();
		if (getName().trim().length() > 0) {
			ret = "<i>" + getName() + ":</i>  " + ret;
		}
		if ((getInput() != null) && (getInput().trim().length() > 0)) {
			ret += ":  " + getInput();
		}

		String adderString = getAdderString();
		if (adderString.trim().length() > 0) {
			ret += " (" + adderString + ")";
		}
		ret += getModifierString();
		if ((getEndUsage() > 0)
				&& (GenericObject.findObjectByID(HeroDesigner.getActiveHero()
						.getPowers(), "ENDURANCERESERVE") != null)
				&& (GenericObject.findObjectByID(getAllAssignedModifiers(),
						"ENDRESERVEOREND") == null)
				&& !HeroDesigner.getInstance().getPrefs().useWG()) {
			if (getUseENDReserve()) {
				ret += " (uses END Reserve)";
			} else {
				ret += " (uses Personal END)";
			}
		}
		return ret;
	}

	@Override
	public String getDamageDisplay() {
		String ret = "";
		return ret;
	}

	/**
	 * The amount to multiply the cost of all Defense Powers by.
	 * 
	 * @return
	 */
	public int getDefenseCostMultiplier() {
		if (defenseCostMultiplier <= 0) {
			defenseCostMultiplier = 1;
		}
		return defenseCostMultiplier;
	}

	@Override
	public GenericDialog getDialog(boolean isNew, boolean isPower) {
		return new PowerDialog(this, isNew, isPower);
	}

	@Override
	protected void init(Element element) {
		duration = "INHERENT";
		target = "SELFONLY";
		range = "SELF";
		end = 0;
		display = "Automaton";
		levelCost = 0;
		levelValue = 0;
		minimumCost = 15;
		baseCost = 15;
		basePDEDDenomenator = 3;
		defenseCostMultiplier = 3;
		super.init(element);
		String check = XMLUtility.getValue(element, "BASEPDEDDENOMENATOR");
		if ((check != null) && (check.trim().length() > 0)) {
			try {
				basePDEDDenomenator = Integer.parseInt(check);
			} catch (NumberFormatException ex) {
			}
		}
		check = XMLUtility.getValue(element, "DEFENSECOSTMULTIPLIER");
		if ((check != null) && (check.trim().length() > 0)) {
			try {
				defenseCostMultiplier = Integer.parseInt(check);
			} catch (NumberFormatException ex) {
			}
		}
	}
}